/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.scoreboard;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.internal.base.ComponentsInternals;
import dev.onyxstudios.cca.internal.scoreboard.CardinalComponentsScoreboard;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_269;
import net.minecraft.class_2960;

public final class CcaScoreboardClient {
    public static void initClient() {
        if (FabricLoader.getInstance().isModLoaded("fabric-networking-api-v1")) {
            CcaScoreboardClient.registerScoreboardSync(CardinalComponentsScoreboard.TEAM_PACKET_ID, buf -> {
                String teamName = buf.method_19772();
                return (componentType, scoreboard) -> componentType.maybeGet((Object)scoreboard.method_1153(teamName));
            });
            CcaScoreboardClient.registerScoreboardSync(CardinalComponentsScoreboard.SCOREBOARD_PACKET_ID, buf -> ComponentKey::maybeGet);
        }
    }

    private static void registerScoreboardSync(class_2960 packetId, Function<class_2540, BiFunction<ComponentKey<?>, class_269, Optional<? extends Component>>> reader) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)packetId, (client, handler, buffer, res) -> {
            try {
                BiFunction getter = (BiFunction)reader.apply(buffer);
                class_2960 componentTypeId = buffer.method_10810();
                ComponentKey componentType = ComponentRegistry.get((class_2960)componentTypeId);
                if (componentType != null) {
                    buffer.retain();
                    client.execute(() -> {
                        try {
                            ((Optional)getter.apply(componentType, handler.method_2890().method_8428())).filter(c -> c instanceof AutoSyncedComponent).ifPresent(c -> ((AutoSyncedComponent)c).applySyncPacket(buffer));
                        }
                        finally {
                            buffer.release();
                        }
                    });
                }
            }
            catch (Exception e) {
                ComponentsInternals.LOGGER.error("Error while reading scoreboard components from network", (Throwable)e);
                throw e;
            }
        });
    }
}

